/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.validacion.ContextoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidableContexto;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores.ModeloValoresRefrendo;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.modelo.util.InfoPantallas;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaRefrendo
extends PaginaAsistente
implements VistaModelo<Exportacion>,
VistaValoresPropios {
    private Text txtNumFUE;
    private Text txtFOB;
    private Text txtAnio;
    private Text txtNumDocTransporte;
    private Text txtCorrelativo;
    private Text txtVerificador;
    private ComboViewer cvTipoExportacion;
    private ComboViewer cvDistritos;
    private ComboViewer cvRegimenes;
    private Label lblRefrendo;
    private Composite compositeRefrendo;
    private Label lblVerificador;
    private Label lblNFue;
    private Text txtValorDelImpuesto;
    private ComboViewer cvTipoIngresoExterior;
    private Label lblTipoDeIngreso;
    private Combo cmbTipoIngresoExterior;
    private Label lblelIngresoDel;
    private Composite compositeIngresoGrabadoOtroPais;
    private Label lblValorDelImpuesto;
    private Button btnSiIngresoGravado;
    private Button btnNoIngresoGravado;
    private boolean editando;
    private Exportacion modeloDatos;
    private ModeloValoresRefrendo modeloValores;

    public PaginaRefrendo(boolean editando) {
        super(PaginaRefrendo.class.getName(), "Detalle Exportaci\u00f3n", "Especifique la informaci\u00f3n correspondiente");
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresRefrendo(this.modeloDatos.isRegimenEcuapass(), ((Iva)this.modeloDatos.getRaizModelo()).periodo);
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(Exportacion modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
        if (this.editando) {
            String codigoRefrendo = this.modeloDatos.getTipoExportacionDe();
            ElementoNombreValor tipoRefrendo = this.modeloValores.obtenerTipoRefrendo(codigoRefrendo);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoExportacion, (Object)tipoRefrendo);
            String ingresoDelExterior = this.modeloDatos.getTipoIngresoDelExterior();
            ElementoNombreValor tipoIngreso = this.modeloValores.obtenerTipoIngresoDelExterior(ingresoDelExterior);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIngresoExterior, (Object)tipoIngreso);
        }
        if (this.modeloDatos.getTipoExportacionDe() == null || this.modeloDatos.getTipoExportacionDe().equals("02")) {
            this.lblRefrendo.setVisible(false);
            this.compositeRefrendo.setVisible(false);
        } else {
            String codigoDistrito = this.modeloDatos.getRefrendo().getTipoDistritoAduanero();
            ElementoNombreValor tipoDistrito = this.modeloValores.obtenerDistrito(codigoDistrito);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvDistritos, (Object)tipoDistrito);
            String codRegimen = this.modeloDatos.getRefrendo().getTipoRegimen();
            ElementoNombreValor tipoRegimen = this.modeloValores.obtenerRegimen(codRegimen);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvRegimenes, (Object)tipoRegimen);
        }
        ContextoValidacion ctxVal = new ContextoValidacion().agregar(InfoPantallas.EXPORTACIONES_REFRENDO.toString(), (Object)InfoPantallas.EXPORTACIONES_REFRENDO);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidableContexto)this.modeloDatos, ctxVal, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
        this.modeloDatos.getRefrendo().addPropertyChangeListener((PropertyChangeListener)listener);
    }

    private void cvTipoIngresoExteriorSelectionChanged() {
        this.cvTipoIngresoExterior.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoDeIngresoSeleccionado = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoDeIngresoSeleccionado != null) {
                    PaginaRefrendo.this.modeloDatos.setTipoIngresoDelExterior((String)tipoDeIngresoSeleccionado.getValor());
                    PaginaRefrendo.this.modeloDatos.setDescripcionTipoIngresoDelExterior(tipoDeIngresoSeleccionado.getNombre());
                }
            }
        });
    }

    private void tipoDeExportacionSelectionChanged() {
        this.cvTipoExportacion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoDeExportacionSeleccionado = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoDeExportacionSeleccionado != null) {
                    String codigoTipoDeExportacion = (String)tipoDeExportacionSeleccionado.getValor();
                    PaginaRefrendo.this.modeloDatos.setTipoExportacionDe(codigoTipoDeExportacion);
                    PaginaRefrendo.this.modeloDatos.setDescripcionTipoExportacionDe(tipoDeExportacionSeleccionado.getNombre());
                    PaginaRefrendo.this.limpiarValoresDeExportacionesSinRefrendo(codigoTipoDeExportacion);
                    PaginaRefrendo.this.limpiarValoresDeExportacionDeServicios(codigoTipoDeExportacion);
                    PaginaRefrendo.this.habilitarInfoIngresosDelExteriorParaExportacionDeServiciosDesdeMayo2016(codigoTipoDeExportacion);
                    PaginaRefrendo.this.lblRefrendo.setVisible(codigoTipoDeExportacion.equals("01"));
                    PaginaRefrendo.this.compositeRefrendo.setVisible(codigoTipoDeExportacion.equals("01"));
                }
            }
        });
    }

    protected void limpiarValoresDeExportacionesSinRefrendo(String tipoExportacion) {
        if (!tipoExportacion.equals("01")) {
            this.modeloDatos.getRefrendo().setAnio("");
            this.modeloDatos.getRefrendo().setCorrelativo("");
            this.modeloDatos.getRefrendo().setNumeroDocTransporte("");
            this.modeloDatos.getRefrendo().setTipoDistritoAduanero(null);
            this.modeloDatos.getRefrendo().setDescripcionTipoDistrito("");
            this.modeloDatos.getRefrendo().setDescripcionTipoDistrito(null);
            this.modeloDatos.getRefrendo().setTipoRegimen(null);
            this.modeloDatos.getRefrendo().setDescripcionTipoRegimen("");
        }
    }

    private void limpiarValoresDeExportacionDeServicios(String codigoTipoDeExportacion) {
        if (!"03".equals(codigoTipoDeExportacion)) {
            this.modeloDatos.setValorImpuestoOtroPais("0.00");
            this.modeloDatos.setEsIngresoDelExteriorGravado(false);
            this.modeloDatos.setTipoIngresoDelExterior(null);
            this.modeloDatos.setDescripcionTipoIngresoDelExterior(null);
            AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIngresoExterior, null);
        }
    }

    protected void habilitarInfoIngresosDelExteriorParaExportacionDeServiciosDesdeMayo2016(String codigoTipoDeExportacion) {
        boolean esExportacionDeServiciosDesdeMayo2016 = "03".equals(codigoTipoDeExportacion) && ((Iva)this.modeloDatos.getPropietario()).periodo.isAnexoEnPeriodoDesdeMayo2016();
        this.lblTipoDeIngreso.setEnabled(esExportacionDeServiciosDesdeMayo2016);
        this.cmbTipoIngresoExterior.setEnabled(esExportacionDeServiciosDesdeMayo2016);
        this.lblelIngresoDel.setEnabled(esExportacionDeServiciosDesdeMayo2016);
        this.compositeIngresoGrabadoOtroPais.setEnabled(esExportacionDeServiciosDesdeMayo2016);
        this.btnSiIngresoGravado.setEnabled(esExportacionDeServiciosDesdeMayo2016);
        this.btnNoIngresoGravado.setEnabled(esExportacionDeServiciosDesdeMayo2016);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTipoDeExportacin = new Label(container, 0);
        lblTipoDeExportacin.setText("Tipo de Exportaci\u00f3n");
        this.cvTipoExportacion = new ComboViewer(container, 8);
        this.tipoDeExportacionSelectionChanged();
        Combo combo = this.cvTipoExportacion.getCombo();
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 371;
        combo.setLayoutData((Object)gd_combo);
        this.lblTipoDeIngreso = new Label(container, 0);
        this.lblTipoDeIngreso.setEnabled(false);
        this.lblTipoDeIngreso.setText("Tipo de Ingreso del Exterior");
        this.cvTipoIngresoExterior = new ComboViewer(container, 8);
        this.cvTipoIngresoExteriorSelectionChanged();
        this.cmbTipoIngresoExterior = this.cvTipoIngresoExterior.getCombo();
        this.cmbTipoIngresoExterior.setEnabled(false);
        GridData gd_cmbTipoIngresoExterior = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbTipoIngresoExterior.widthHint = 250;
        this.cmbTipoIngresoExterior.setLayoutData((Object)gd_cmbTipoIngresoExterior);
        this.lblelIngresoDel = new Label(container, 0);
        this.lblelIngresoDel.setEnabled(false);
        this.lblelIngresoDel.setText("\u00bfEl ingreso del exterior fue \n gravado con impuesto a la renta \n o uno similar, en el pa\u00eds en el \nque se obtuvo?");
        this.compositeIngresoGrabadoOtroPais = new Composite(container, 0);
        this.compositeIngresoGrabadoOtroPais.setEnabled(false);
        this.compositeIngresoGrabadoOtroPais.setLayout((Layout)new GridLayout(2, false));
        this.btnSiIngresoGravado = new Button(this.compositeIngresoGrabadoOtroPais, 16);
        this.btnSiIngresoGravado.setEnabled(false);
        this.btnSiIngresoGravado.setText("SI");
        this.btnNoIngresoGravado = new Button(this.compositeIngresoGrabadoOtroPais, 16);
        this.btnNoIngresoGravado.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaRefrendo.this.txtValorDelImpuesto.setText("0.00");
            }
        });
        this.btnNoIngresoGravado.setEnabled(false);
        this.btnNoIngresoGravado.setText("NO");
        this.lblValorDelImpuesto = new Label(container, 0);
        this.lblValorDelImpuesto.setEnabled(false);
        this.lblValorDelImpuesto.setText("Valor del impuesto a la renta o \n impuesto similar pagado en el \n exterior por el ingreso obtenido");
        this.txtValorDelImpuesto = new Text(container, 2048);
        this.txtValorDelImpuesto.setEditable(false);
        this.txtValorDelImpuesto.setTextLimit(15);
        GridData gd_txtValorDelImpuesto = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtValorDelImpuesto.widthHint = 118;
        this.txtValorDelImpuesto.setLayoutData((Object)gd_txtValorDelImpuesto);
        Label lblValorFob = new Label(container, 0);
        lblValorFob.setText("Valor FOB / Valor del ingreso del exterior");
        this.txtFOB = new Text(container, 2048);
        this.txtFOB.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaRefrendo.this.txtFOB.selectAll();
            }
        });
        this.txtFOB.setTextLimit(15);
        GridData gd_txtFOB = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtFOB.widthHint = 118;
        this.txtFOB.setLayoutData((Object)gd_txtFOB);
        Label lblFechaDeLa = new Label(container, 0);
        GridData gd_lblFechaDeLa = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblFechaDeLa.widthHint = 173;
        lblFechaDeLa.setLayoutData((Object)gd_lblFechaDeLa);
        lblFechaDeLa.setText("Fecha de la transacci\u00f3n");
        final CDateTime dtFechaTransaccion = new CDateTime(container, 32771);
        dtFechaTransaccion.setNullText("seleccione la fecha");
        dtFechaTransaccion.setPattern("dd/MM/yyyy");
        dtFechaTransaccion.setSelection(this.modeloDatos.getFechaTransaccion());
        dtFechaTransaccion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaRefrendo.this.modeloDatos.setFechaTransaccion(dtFechaTransaccion.getSelection());
            }
        });
        GridData gd_dtFechaTransaccion = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dtFechaTransaccion.widthHint = 125;
        dtFechaTransaccion.setLayoutData((Object)gd_dtFechaTransaccion);
        this.lblNFue = new Label(container, 0);
        this.lblNFue.setText("N\u00b0 FUE");
        this.txtNumFUE = new Text(container, 2048);
        this.txtNumFUE.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaRefrendo.this.txtNumFUE.selectAll();
            }
        });
        this.txtNumFUE.setTextLimit(13);
        GridData gd_txtNumFUE = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumFUE.widthHint = 118;
        this.txtNumFUE.setLayoutData((Object)gd_txtNumFUE);
        this.lblRefrendo = new Label(container, 0);
        GridData gd_lblRefrendo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRefrendo.verticalIndent = 10;
        this.lblRefrendo.setLayoutData((Object)gd_lblRefrendo);
        this.lblRefrendo.setText("Refrendo");
        this.lblRefrendo.setFont(SWTResourceManager.getBoldFont((Font)this.lblRefrendo.getFont()));
        new Label(container, 0);
        this.compositeRefrendo = new Composite(container, 0);
        GridLayout gl_compositeRefrendo = new GridLayout(7, false);
        gl_compositeRefrendo.marginWidth = 0;
        this.compositeRefrendo.setLayout((Layout)gl_compositeRefrendo);
        this.compositeRefrendo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        Label lblN = new Label(this.compositeRefrendo, 0);
        GridData gd_lblN = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblN.widthHint = 173;
        lblN.setLayoutData((Object)gd_lblN);
        lblN.setText("N\u00b0 Documento  de Transporte");
        this.txtNumDocTransporte = new Text(this.compositeRefrendo, 2048);
        this.txtNumDocTransporte.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaRefrendo.this.txtNumDocTransporte.selectAll();
            }
        });
        this.txtNumDocTransporte.setTextLimit(13);
        GridData gd_txtNumDocTransporte = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtNumDocTransporte.widthHint = 118;
        this.txtNumDocTransporte.setLayoutData((Object)gd_txtNumDocTransporte);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        Label lblDistrito = new Label(this.compositeRefrendo, 0);
        lblDistrito.setText("Distrito");
        this.cvDistritos = new ComboViewer(this.compositeRefrendo, 8);
        this.cvDistritos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor distrito = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (distrito != null) {
                    PaginaRefrendo.this.modeloDatos.getRefrendo().setTipoDistritoAduanero((String)distrito.getValor());
                    PaginaRefrendo.this.modeloDatos.getRefrendo().setDescripcionTipoDistrito(distrito.getNombre());
                }
            }
        });
        Combo cmbDistritos = this.cvDistritos.getCombo();
        GridData gd_cmbDistritos = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_cmbDistritos.widthHint = 150;
        cmbDistritos.setLayoutData((Object)gd_cmbDistritos);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        Label lblAo = new Label(this.compositeRefrendo, 0);
        lblAo.setText("A\u00f1o");
        this.txtAnio = new Text(this.compositeRefrendo, 2048);
        this.txtAnio.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaRefrendo.this.txtAnio.selectAll();
            }
        });
        this.txtAnio.setTextLimit(4);
        GridData gd_txtAnio = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_txtAnio.widthHint = 118;
        this.txtAnio.setLayoutData((Object)gd_txtAnio);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        Label lblRgimen = new Label(this.compositeRefrendo, 0);
        lblRgimen.setText("R\u00e9gimen");
        this.cvRegimenes = new ComboViewer(this.compositeRefrendo, 8);
        this.cvRegimenes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor regimen = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (regimen != null) {
                    PaginaRefrendo.this.modeloDatos.getRefrendo().setTipoRegimen((String)regimen.getValor());
                    PaginaRefrendo.this.modeloDatos.getRefrendo().setDescripcionTipoRegimen(regimen.getNombre());
                }
            }
        });
        Combo combo_2 = this.cvRegimenes.getCombo();
        GridData gd_combo_2 = new GridData(16384, 0x1000000, false, false, 6, 1);
        gd_combo_2.widthHint = 360;
        combo_2.setLayoutData((Object)gd_combo_2);
        Label lblCorrelativo = new Label(this.compositeRefrendo, 0);
        lblCorrelativo.setText("Correlativo");
        this.txtCorrelativo = new Text(this.compositeRefrendo, 2048);
        this.txtCorrelativo.setTextLimit(8);
        GridData gd_txtCorrelativo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtCorrelativo.widthHint = 118;
        this.txtCorrelativo.setLayoutData((Object)gd_txtCorrelativo);
        this.lblVerificador = new Label(this.compositeRefrendo, 0);
        this.lblVerificador.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblVerificador.setText("Verificador");
        this.txtVerificador = new Text(this.compositeRefrendo, 2048);
        this.txtVerificador.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaRefrendo.this.txtVerificador.selectAll();
            }
        });
        this.txtVerificador.setTextLimit(1);
        GridData gd_txtVerificador = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtVerificador.widthHint = 35;
        this.txtVerificador.setLayoutData((Object)gd_txtVerificador);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        new Label(this.compositeRefrendo, 0);
        this.initDataBindings();
        this.procesarModeloDatos();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoExportacion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoExportacion.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposRefrendoModeloValoresObserveList = PojoProperties.list((String)"tiposRefrendo").observe((Object)this.modeloValores);
        this.cvTipoExportacion.setInput((Object)tiposRefrendoModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap_1 = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvDistritos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_1));
        this.cvDistritos.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList distritosModeloValoresObserveList = PojoProperties.list((String)"distritos").observe((Object)this.modeloValores);
        this.cvDistritos.setInput((Object)distritosModeloValoresObserveList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvRegimenes.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvRegimenes.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList regimenesModeloValoresObserveList = PojoProperties.list((String)"regimenes").observe((Object)this.modeloValores);
        this.cvRegimenes.setInput((Object)regimenesModeloValoresObserveList);
        ISWTObservableValue observeTextTxtNumFUEObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumFUE);
        IObservableValue numeroFueModeloDatosObserveValue = BeanProperties.value((String)"numeroFue").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumFUEObserveWidget, numeroFueModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtFOBObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtFOB);
        IObservableValue valorFobModeloDatosObserveValue = BeanProperties.value((String)"valorFob").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtFOBObserveWidget, valorFobModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumDocTransporteObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumDocTransporte);
        IObservableValue refrendonumeroDocTransporteModeloDatosObserveValue = BeanProperties.value((String)"refrendo.numeroDocTransporte").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumDocTransporteObserveWidget, refrendonumeroDocTransporteModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtAnioObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtAnio);
        IObservableValue refrendoanioModeloDatosObserveValue = BeanProperties.value((String)"refrendo.anio").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtAnioObserveWidget, refrendoanioModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtCorrelativoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtCorrelativo);
        IObservableValue refrendocorrelativoModeloDatosObserveValue = BeanProperties.value((String)"refrendo.correlativo").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtCorrelativoObserveWidget, refrendocorrelativoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtVerificadorObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtVerificador);
        IObservableValue refrendoverificadorModeloDatosObserveValue = BeanProperties.value((String)"refrendo.verificador").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtVerificadorObserveWidget, refrendoverificadorModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledTxtVerificadorObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtVerificador);
        IObservableValue refrendoflagVerificadorModeloDatosObserveValue = BeanProperties.value((String)"refrendo.flagVerificador").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeEnabledTxtVerificadorObserveWidget, refrendoflagVerificadorModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLblVerificadorObserveWidget = WidgetProperties.enabled().observe((Widget)this.lblVerificador);
        bindingContext.bindValue((IObservableValue)observeEnabledLblVerificadorObserveWidget, refrendoflagVerificadorModeloDatosObserveValue, null, null);
        ISWTObservableValue lblNFueObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblNFue);
        bindingContext.bindValue((IObservableValue)lblNFueObserveVisibleObserveWidget, refrendoflagVerificadorModeloDatosObserveValue, null, null);
        ISWTObservableValue txtNumFUEObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.txtNumFUE);
        bindingContext.bindValue((IObservableValue)txtNumFUEObserveVisibleObserveWidget, refrendoflagVerificadorModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider_3 = new ObservableListContentProvider();
        IObservableMap observeMap_3 = PojoObservables.observeMap((IObservableSet)listContentProvider_3.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIngresoExterior.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_3));
        this.cvTipoIngresoExterior.setContentProvider((IContentProvider)listContentProvider_3);
        IObservableList modeloValoresTiposDeIngresoDelExteriorObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposDeIngresoDelExterior");
        this.cvTipoIngresoExterior.setInput((Object)modeloValoresTiposDeIngresoDelExteriorObserveList);
        ISWTObservableValue txtValorDelImpuestoObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtValorDelImpuesto, (int)24);
        IObservableValue modeloDatosValorImpuestoOtroPaisObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"valorImpuestoOtroPais");
        bindingContext.bindValue((IObservableValue)txtValorDelImpuestoObserveTextObserveWidget, modeloDatosValorImpuestoOtroPaisObserveValue, null, null);
        ISWTObservableValue btnSiIngresoGravadoObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiIngresoGravado);
        IObservableValue modeloDatosEsIngresoDelExteriorGravadoObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"esIngresoDelExteriorGravado");
        bindingContext.bindValue((IObservableValue)btnSiIngresoGravadoObserveSelectionObserveWidget, modeloDatosEsIngresoDelExteriorGravadoObserveValue, null, null);
        ISWTObservableValue btnNoIngresoGravadoObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoIngresoGravado);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoIngresoGravadoObserveSelectionObserveWidget, modeloDatosEsIngresoDelExteriorGravadoObserveValue, strategy, strategy_1);
        ISWTObservableValue lblValorDelImpuestoObserveEnabledObserveWidget = SWTObservables.observeEnabled((Control)this.lblValorDelImpuesto);
        bindingContext.bindValue((IObservableValue)lblValorDelImpuestoObserveEnabledObserveWidget, modeloDatosEsIngresoDelExteriorGravadoObserveValue, null, null);
        ISWTObservableValue txtValorDelImpuestoObserveEditableObserveWidget = SWTObservables.observeEditable((Control)this.txtValorDelImpuesto);
        bindingContext.bindValue((IObservableValue)txtValorDelImpuestoObserveEditableObserveWidget, modeloDatosEsIngresoDelExteriorGravadoObserveValue, null, null);
        return bindingContext;
    }
}

